;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    dispatch.cl      Hans Groschwitz     08.10.94    ;;
;;                                                     ;;
;;    Dispatcher for User Defined Message Handlers     ;;
;;                                                     ;;
;;    In spite of channel numbers :keywords should be  ;;
;;    used to simplify reorganisation of channelno's!  ;;
;;                                                     ;;
;;    Channels 0-9 are reserved for special purposes!  ;;
;;    Channels 10-999 may be used by the programmer!   ;;
;;                                                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "BABYLON")

; -------------------------------------------

(defun emaxps-dispatch (channelno)
 (case channelno
  ;;-------------------------UIDs--------;;
  (:uid-information            		10)
  (:uid-accept-cancel          		11)
  (:uid-yes-no-cancel          		12)
  (:uid-prompt                 		13)
  (:uid-one-of-many            		14)
  (:uid-some-of-many           		15)
  ;(NIL                                 16)
  ;(NIL                                 17)
  ;(NIL                                 18)
  ;(NIL                                 19)
  ;;-----------------------UImisc--------;;
  (:ui-destroy-widget          		20)
  (:ui-raise-to-top            		21)
  (:ui-lower-to-bottom         		22)
  (:ui-create-simple-session-screen     23)
  (:ui-stop-session                     24)
  (:ui-save                             25)
  ;(NIL                                 26)
  ;(NIL                                 27)
  ;(NIL                                 28)
  ;(NIL                                 29)
  ;;---------------------UIcreate--------;;
  (:ui-create-pushbutton       		30)
  (:ui-create-label            		31)
  (:ui-create-bitmap-button    		32)
  (:ui-create-bitmap-label     		33)
  (:ui-create-input-text       		34)
  (:ui-create-output-text      		35)
  (:ui-create-pulldown-menu    		36)
  (:ui-create-menu-entry       		37)
  (:ui-create-separator        		38)
  ;(NIL                                 39)
  ;;-------------------------------------;;
  ;(NIL                                 40)
  ;(NIL                                 41)
  ;(NIL                                 42)
  ;(NIL                                 43)
  ;(NIL                                 44)
  ;(NIL                                 45)
  ;(NIL                                 46)
  ;(NIL                                 47)
  ;(NIL                                 48)
  ;(NIL                                 49)
  ;;------------------------UIset--------;;
  (:ui-set-session-bg  	                50)
  (:ui-set-menu-bg                      51)
  (:ui-set-menu-fg                      52)
  (:ui-set-menu-font           		53)
  (:ui-set-visibility          		54)
  (:ui-set-sensitivity         		55)
  (:ui-set-foreground          		56)
  (:ui-set-background          		57)
  (:ui-set-font                		58)
  (:ui-set-bitmap              		59)
  ;;-------------------------------------;;
  (:ui-set-geometry            		60)
  (:ui-set-alignment           		61)
  (:ui-set-text                		62)
  (:ui-add-text                		63)
  (:ui-set-callback            		64)
  (:ui-set-mnemonic            		65)
  ;(NIL                                 66)
  ;(NIL                                 67)
  ;(NIL                                 68)
  ;(NIL                                 69)
  ;;------------------------UIget--------;;
  (:ui-get-session-bg                   70)
  (:ui-get-menu-bg                      71)
  (:ui-get-menu-fg                      72)
  (:ui-get-menu-font                    73)
  (:ui-get-visibility                   74)
  (:ui-get-sensitivity                  75)
  (:ui-get-foreground                   76)
  (:ui-get-background                   77)
  (:ui-get-font        		        78)
  (:ui-get-bitmap               	79)
  ;;-------------------------------------;;
  (:ui-get-geometry                     80)
  (:ui-get-alignment                    81)
  (:ui-get-text                         82)
  (:ui-get-callback                     83)
  (:ui-get-mnemonic                     84)
  ;(NIL                                 85)
  ;(NIL                                 86)
  ;(NIL                                 87)
  ;(NIL                                 88)
  ;(NIL                                 89)
  ;;-------------------------SYSd--------;;
  (:sysd-warning                        90)
  (:sysd-information                    91)
  (:sysd-accept-cancel                  92)
  (:sysd-prompt                         93)
  ;(NIL                                 94)
  ;(NIL                                 95)
  ;(NIL                                 96)
  ;(NIL                                 97)
  ;(NIL                                 98)
  ;(NIL                                 99)
  ;;-------------------------------------;;
  ;(NIL                                100)
  ;(NIL                                101)
  ;(NIL                                102)
  ;(NIL                                103)
  ;(NIL                                104)
  ;(NIL                                105)
  ;(NIL                                106)
  ;(NIL                                107)
  ;(NIL                                108)
  ;(NIL                                109)
  ;;----------------------Explain--------;;
  (:explain-message                    110)
  (:expd-one-of-many                   111)
  (:expd-one-of-many2                  112)
  (:expd-some-of-many                  113)
  (:expd-message                       114)
  ;(NIL                                115)
  ;(NIL                                116)
  ;(NIL                                117)
  ;(NIL                                118)
  ;(NIL                                119)
  ;;------------------------Trace--------;;
  (:trace-message                      120)
  (:trace-task-toggle                  121)
  (:trace-system-toggle                122)
  (:trace-rule-toggle                  123)
  (:trace-prolog-toggle                124)
  (:trace-constraint-toggle            125)
  ;(NIL                                126)
  ;(NIL                                127)
  ;(NIL                                128)
  ;(NIL                                129)
  ;;------------------------Frame--------;;
  (:emaxps-frame-definition            130)
  (:emaxps-frame-check-on              131)
  (:emaxps-frame-selection             132)
  (:emaxps-frame-delete                133)
  (:emaxps-instance-definition         134)
  (:emaxps-inst-frame-selection        135)  
  (:emaxps-inst-instance-selection     136)
  (:emaxps-behavior-definition         137)
  (:emaxps-behav-frame-selection       138)
  (:emaxps-behav-behavior-selection    139)
  ;;-------------------------------------;;
  ;(NIL                                140)
  ;(NIL                                141)
  ;(NIL                                142)
  ;(NIL                                143)
  ;(NIL                                144)
  ;(NIL                                145)
  ;(NIL                                146)
  ;(NIL                                147)
  ;(NIL                                148)
  ;(NIL                                149)
  ;;-------------------------Rule--------;;
  (:emaxps-rule-get-rsets-of-kb        150)
  (:emaxps-rule-get-rules-of-rset      151)
  (:emaxps-rule-get-body-of-rule       152)
  (:emaxps-rule-get-rules-of-rset2     153)
  ;(NIL                                154)
  ;(NIL                                155)
  ;(NIL                                156)
  ;(NIL                                157)
  ;(NIL                                158)
  ;(NIL                                159)
  ;;-------------------------------------;;
  ;(NIL                                160)
  ;(NIL                                161)
  ;(NIL                                162)
  ;(NIL                                163)
  ;(NIL                                164)
  ;(NIL                                165)
  ;(NIL                                166)
  ;(NIL                                167)
  ;(NIL                                168)
  ;(NIL                                169)
  ;;-----------------------Prolog--------;;
  (:emaxps-prolog-klauselmengen-def    170)
  (:emaxps-prolog-select               171)
  (:emaxps-new-axioms                  172)
  (:emaxps-new-kbaxiom                 173)
  (:emaxps-del-kbaxiom                 174)
  (:emaxps-reset-prolog-of-kb          175)
  ;(NIL                                176)
  ;(NIL                                177)
  ;(NIL                                178)
  ;(NIL                                179)
  ;;-------------------------------------;;
  ;(NIL                                180)
  ;(NIL                                181)
  ;(NIL                                182)
  ;(NIL                                183)
  ;(NIL                                184)
  ;(NIL                                185)
  ;(NIL                                186)
  ;(NIL                                187)
  ;(NIL                                188)
  ;(NIL                                189)
  ;;-----------------------Consat--------;;
  (:emaxps-constraint-def              190)
  (:emaxps-constraint-sel              191)
  (:emaxps-restriction-def             192)
  (:emaxps-restriction-sel             193)
  (:emaxps-csnet-def                   194)
  (:emaxps-csnet-sel                   195)
  ;(NIL                                196)
  ;(NIL                                197)
  ;(NIL                                198)
  ;(NIL                                199)
  ;;-------------------------------------;;
  ;(NIL                                200)
  ;(NIL                                201)
  ;(NIL                                202)
  ;(NIL                                203)
  ;(NIL                                204)
  ;(NIL                                205)
  ;(NIL                                206)
  ;(NIL                                207)
  ;(NIL                                208)
  ;(NIL                                209)
  ;;-------------------------Task--------;;
  (:emaxps-task-list-tasks             210)
  (:emaxps-task-send-body              211)
  (:emaxps-misc-send-others            212)
  ;(NIL                                213)
  ;(NIL                                214)
  ;(NIL                                215)
  ;(NIL                                216)
  ;(NIL                                217)
  ;(NIL                                218)
  ;(NIL                                219)
  ;;-------------------------------------;;
  ;(NIL                                220)
  ;(NIL                                221)
  ;(NIL                                222)
  ;(NIL                                223)
  ;(NIL                                224)
  ;(NIL                                225)
  ;(NIL                                226)
  ;(NIL                                227)
  ;(NIL                                228)
  ;(NIL                                229)
  ;;---------------------Reserved--------;;
  (otherwise
   (emaxps-error "emaxps-dispatch:
 ~S is not a known keyword representing a message channel" channelno))
 );case
)

;; eof
